<?php
require_once("dbcontroller.php");
$db_handle = new DBController();
$result = $db_handle->runQuery("SELECT employees.id,employees.first_name,employees.phone,employees.pco_number,employees.driver_photo,employees.address,employees.post_code,vehicles.mot_date,vehicles.reg
FROM employees
JOIN vehicles on vehicles.driver_id=employees.id");
$header = $db_handle->runQuery("SELECT `COLUMN_NAME` 
FROM `INFORMATION_SCHEMA`.`COLUMNS` 
WHERE `TABLE_SCHEMA`='ezycab' 
    AND `TABLE_NAME`='employees'");

require('../pdf_demo/fpdf.php');

// Begin configuration

$textColour = array( 0, 0, 0 );
$headerColour = array( 100, 100, 100 );
$tableHeaderTopTextColour = array( 255, 255, 255 );
$tableHeaderTopFillColour = array( 125, 152, 179 );
$tableHeaderTopProductTextColour = array( 0, 0, 0 );
$tableHeaderTopProductFillColour = array( 143, 173, 204 );
$tableHeaderLeftTextColour = array( 99, 42, 57 );
$tableHeaderLeftFillColour = array( 184, 207, 229 );
$tableBorderColour = array( 50, 50, 50 );
$tableRowFillColour = array( 213, 170, 170 );
$reportName = "2009 Widget Sales Report";
$reportNameYPos = 160;
$logoFile = "widget-company-logo.png";
$logoXPos = 50;
$logoYPos = 108;
$logoWidth = 110;
$columnLabels = array( "Driver Name", "PCO Number", "MOT Date", "Insurance Date" );
$rowLabels = array( "SupaWidget", "WonderWidget", "MegaWidget", "HyperWidget" );
$chartXPos = 20;
$chartYPos = 250;
$chartWidth = 160;
$chartHeight = 80;
$chartXLabel = "Product";
$chartYLabel = "2009 Sales";
$chartYStep = 20000;

$chartColours = array(
                  array( 255, 100, 100 ),
                  array( 100, 255, 100 ),
                  array( 100, 100, 255 ),
                  array( 255, 255, 100 ),
                );

$data = array(
          array( 9940, 10100, 9490, 11730 ),
          array( 19310, 21140, 20560, 22590 ),
          array( 25110, 26260, 25210, 28370 ),
          array( 27650, 24550, 30040, 31980 ),
        );

// End configuration



$count=count($result);
$pdf = new FPDF();
$pdf->AddPage('L','A4');


$pdf->SetTextColor( $textColour[0], $textColour[1], $textColour[2] );
$pdf->SetFont( 'Arial', '', 20 );
$pdf->Write( 19, "List of Drivers" );

$pdf->Ln(15);
// Create the table header row
$pdf->SetFont( 'Arial', 'B', 15 );

// Create the table header row
$pdf->SetFont( 'Arial', 'B', 15 );

// "PRODUCT" cell
$pdf->SetTextColor( $tableHeaderTopProductTextColour[0], $tableHeaderTopProductTextColour[1], $tableHeaderTopProductTextColour[2] );
$pdf->SetFillColor( $tableHeaderTopProductFillColour[0], $tableHeaderTopProductFillColour[1], $tableHeaderTopProductFillColour[2] );

// Remaining header cells
$pdf->SetTextColor( $tableHeaderTopTextColour[0], $tableHeaderTopTextColour[1], $tableHeaderTopTextColour[2] );
$pdf->SetFillColor( $tableHeaderTopFillColour[0], $tableHeaderTopFillColour[1], $tableHeaderTopFillColour[2] );

for ( $i=0; $i<count($columnLabels); $i++ ) {
  $pdf->Cell( 40, 12, $columnLabels[$i], 1, 0, 'C', true );
}

$pdf->Ln( 12 );

$validColumn = array('id','first_name','pco_number','mot_date');
 foreach($result[0] as $key=>$value)
 {
 	if(array_search($key,$validColumn) !== false)
 	{
		
 		//$pdf->Cell(40,12,$key, 1, 0, 'L', true);
 	}
	
 }

$pdf->Ln(2 );
$pdf->SetFont('Arial','B',12);

 foreach($result as $key=>$value)
 {
 	foreach($value as $innerkey=>$innervalue)
 	{echo '<pre>';
print_r($innervalue);
echo '</pre>';

 	    if(array_search($innerkey,$validColumn) !== false)
 		{
			
			
			// Create the data cells
  $pdf->SetTextColor( $textColour[0], $textColour[1], $textColour[2] );
  $pdf->SetFillColor( $tableRowFillColour[0], $tableRowFillColour[1], $tableRowFillColour[2] );
  $pdf->SetFont( 'Arial', '', 12 );
			//$innervalue[3]=date("d/m/Y",strtotime($innervalue[3]));
 			$pdf->Cell(40,12,$innervalue,1);
 		}
		
 	}
 	$pdf->Ln();
 }

$pdf->Output();
?>