<?php
error_reporting(E_ALL);
include "../dbconfig.php";
$sql="SELECT invoices.invoice_no,invoices.date, invoices.customer_id, customers.name,invoices.nett, invoices.vat,invoices.gross, invoices.status status_id,
invoice_status.name as status
FROM invoices
LEFT JOIN invoice_status ON invoices.status = invoice_status.id
LEFT JOIN customers ON invoices.customer_id = customers.id order by invoices.invoice_no DESC"; // this is main big SQL Query to fetch data
//echo $sql;
include "../pdf_demo/fpdf.php";

// Define Header and Footer inside the class /////////////////////////////////////
class PDF extends FPDF
{
function Header()
{
	$this->SetY(5);  
    $this->SetFont('Arial', 'B', 20); 
    $this->SetFillColor(0,0,125); 
    $this->SetTextColor(225); 
    $this->Cell(0, 10, "List of Invoices", 0, 0, 'L', true); 
	
    $this->SetTextColor(0);
    $this->SetFont('Arial', '', 12); 
	$this->Ln(10);
	$this->Cell(100, 10, "Limo Chauffers Ltd.,",0,1);
	$this->SetY(20);
	$this->Cell(100, 10, "12 Lampton Park Road,",0,1);
    $this->SetY(25);;
	$this->Cell(100, 10, "Hounslow,",0,1);
    $this->SetY(30);
	$this->Cell(100, 10, "Middlesex",0,1);
	$this->SetY(35);
	$this->Cell(100, 10, "TW3 4HS ",0,1);
	 $this->SetY(40);
	$this->Cell(100, 10, "United Kingdom ",0,1); 

	$this->SetXY(115,15);   
    $this->SetTextColor(0); 
 	$this->SetFont('Arial', '', 10); 
	$this->Cell(100, 10, "Phone: (0)2082304594",0,1);
	$this->Ln(8);
	$this->SetXY(115,20);   
	$this->Cell(100, 10, "Mobile:(0)7808939220,",0,1);
	$this->Ln(8);
	$this->SetXY(115,25);
	$this->Cell(100, 10, "Email: info@limochauffeurs.com",0,1);
	$this->Ln(3);
	$this->SetXY(115,30);
	
	$this->Cell(100, 10, "Website: www.limochauffeurs.com");
	$this->SetFont('Arial', 'B', 11); 
	$this->Ln(3);
	$this->SetXY(115,35);
	
	$this->Cell(100, 10, "VAT No: 1234569898");
	// Set up the Invoice To Data
}
 //footer
 function Footer() { 
    $this->SetFont('Arial', '', 10); 
    $this->SetTextColor(0); 
    $this->SetY(-15);
	$this->Cell(0, 20, "Limo Chauffeurs Ltd", 'T', 1, 'C');
    
    $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C'); 
	
	//$this->Image('footer.JPG',0,750,620,50); 
}
}
	  $pdf=new PDF();
	  define('£',chr(163));
	  //Add first page
	  $pdf->AddPage('L');
	  $pdf->SetFont( 'Arial', '', 20 );
	  $pdf->SetAutoPageBreak(false);
	  $y_axis_initial = 50;
 
	  $pdf->SetX(10);
  
$pdf->SetFont('Arial', 'B', 12);
$pdf->SetY($y_axis_initial);
$pdf->SetX(10);
        $pdf->SetFillColor(153,204,255); 
		
        $pdf->Cell(20, 6, 'Sr.No.', 1, 0, 'L', 1);
        $pdf->Cell(30, 6, 'Invoice No.', 1, 0, 'L', 1);
        $pdf->Cell(30, 6, 'Date', 1, 0, 'L', 1);
        $pdf->Cell(60, 6, 'Company', 1, 0, 'L', 1);
		$pdf->Cell(30, 6, 'Nett', 1, 0, 'L', 1);
		$pdf->Cell(30, 6, 'VAT', 1, 0, 'L', 1);
        $pdf->Cell(30, 6, 'Gross', 1, 0, 'L', 1);
        $pdf->Cell(30, 6, 'Status', 1, 0, 'R', 1);

$row_height = 6;
$y_axis = 50;
$y_axis = $y_axis + $row_height;
//echo $sql;
//exit;
$report=mysqli_query($con,$sql);

//initialize counter
$i = 0;

//Set maximum rows per page
$max = 3;

//Set Row Height

 $No = 0;
while($row = mysqli_fetch_array($report))
{
    // Reterive all variables from database
	$No = $No +1;
    $invoice_no = $row['invoice_no'];
	$date = $row['date'];
	$date =date("d/m/Y",strtotime($date));
	$company = $row['name'];
    $nett = number_format($row['nett'],2);
	$vat = number_format($row['vat'],2);
	
	$gross = number_format($row['gross'],2);
    $status = $row['status'];
	//If the current row is the last one, create new page and print column title
    if ($i == $max)
    {
        $pdf->AddPage('L');

        //print column titles for the current page
        $pdf->SetY($y_axis_initial);
        $pdf->SetX(10);
		$pdf->Cell(20, 6, 'Sr.No.', 1, 0, 'L', 1);
        $pdf->Cell(30, 6, 'Invoice No.', 1, 0, 'L', 1);
		$pdf->Cell(30, 6, 'Date', 1, 0, 'L', 1);
        $pdf->Cell(60, 6, 'Company', 1, 0, 'L', 1);
		$pdf->Cell(30, 6, 'Nett', 1, 0, 'L', 1);
		$pdf->Cell(30, 6, 'VAT', 1, 0, 'L', 1);
        $pdf->Cell(30, 6, 'Gross', 1, 0, 'L', 1);
        $pdf->Cell(30, 6, 'Status', 1, 0, 'R', 1);

        //Go to next row
        $y_axis = $y_axis + $row_height;
		
        //Set $i variable to 0 (first row)
        $i = 0;
    }
    

    $pdf->SetY($y_axis);
    $pdf->SetX(10);
	$pdf->Cell(20, 6, $No, 1, 0, 'L', 1);
    $pdf->Cell(30, 6, $invoice_no, 1, 0, 'L', 1);
	$pdf->Cell(30, 6, $date, 1, 0, 'L', 1);
	$pdf->Cell(60, 6, $company, 1, 0, 'L', 1);
	$pdf->Cell(30, 6, £.$nett, 1, 0, 'R', 1);
	$pdf->Cell(30, 6, £.$vat, 1, 0, 'R', 1);
    $pdf->Cell(30, 6, £.$gross, 1, 0, 'R', 1);
    $pdf->Cell(30, 6, $status, 1, 0, 'R', 1);

    //Go to next row
    $y_axis = $y_axis + $row_height;
	
    $i = $i + 1;
	$total_net =number_format($total_net+$nett,2);
	$total_vat =number_format($total_vat+$vat,2);
	$total_gross =number_format($total_gross+$gross,2);
}
$pdf->SetFillColor(0,0,255);
$pdf->SetTextColor(255,255,255);
$pdf->SetFont( 'Arial', '', 15);
$pdf->SetXY(120,$y_axis);
$pdf->Cell(30, 6, "Totals", 1, 0, 'R', 1);
$pdf->SetXY(150,$y_axis);
$pdf->Cell(30, 6, £.$total_net, 1, 0, 'R', 1);
$pdf->SetXY(180,$y_axis);
$pdf->Cell(30, 6, £.$total_vat, 1, 0, 'R', 1);
$pdf->SetXY(210,$y_axis);
$pdf->Cell(30, 6, £.$total_gross, 1, 0, 'R', 1);

//Create file
ob_clean();
$pdf->Output();

?>