<?php
error_reporting(E_ALL);
require('pdf_demo/fpdf.php');
// create new PDF document
$oPdf = new FPDF();

$oPdf->SetMargins(20, 20, 20);

//set default font/colors
$oPdf->SetFont('arial', '', 11);
$oPdf->SetTextColor(200, 10, 10);
$oPdf->SetFillColor(254, 255, 245);

//add the page
$oPdf->AddPage();
$oPdf->AliasNbPages();
$oTable = new FpdfTable($oFpdf);

//Set the tag styles
$oTable->setStyle("p","times","",10,"130,0,30");
$oTable->setStyle("b","times","",9,"80,80,260");
$oTable->setStyle("h1","arial","",10,"0,151,200");
$oTable->setStyle("h2","times","BI",12,"0,0,120");

//Initialize the table class, the table will have 3 columns with the specified widths
$oTable->initialize(array(40, 40, 50));
$aDefaultConfiguration = array(

        'TABLE' => array(
                'TABLE_ALIGN'       => 'C',                 //table align on page
                'TABLE_LEFT_MARGIN' => 0,                   //space to the left margin
                'BORDER_COLOR'      => array(0,92,177),     //border color
                'BORDER_SIZE'       => '0.3',               //border size
                'BORDER_TYPE'       => '1',                 //border type, can be: 0, 1
        ),

        'HEADER' => array(
                'TEXT_COLOR'        => array(220,230,240),  //text color
                'TEXT_SIZE'         => 8,                   //font size
                'TEXT_FONT'         => 'Arial',             //font family
                'TEXT_ALIGN'        => 'C',                 //horizontal alignment, possible values: LRC (left, right, center)
                'VERTICAL_ALIGN'    => 'M',                 //vertical alignment, possible values: TMB(top, middle, bottom)
                'TEXT_TYPE'         => 'B',                 //font type
                'LINE_SIZE'         => 4,                   //line size for one row
                'BACKGROUND_COLOR'  => array(41, 80, 132),  //background color
                'BORDER_COLOR'      => array(0,92,177),     //border color
                'BORDER_SIZE'       => 0.2,                 //border size
                'BORDER_TYPE'       => '1',                 //border type, can be: 0, 1 or a combination of: "LRTB" 
                'TEXT'              => ' ',                 //default text
                //padding
                'PADDING_TOP'       => 0,                   //padding top
                'PADDING_RIGHT'     => 1,                   //padding right
                'PADDING_LEFT'      => 1,                   //padding left
                'PADDING_BOTTOM'    => 0,                   //padding bottom
        ),

        'ROW' => array(
                'TEXT_COLOR'        => array(0,0,0),        //text color
                'TEXT_SIZE'         => 6,                   //font size
                'TEXT_FONT'         => 'Arial',             //font family
                'TEXT_ALIGN'        => 'C',                 //horizontal alignment, possible values: LRC (left, right, center)
                'VERTICAL_ALIGN'    => 'M',                 //vertical alignment, possible values: TMB(top, middle, bottom)
                'TEXT_TYPE'         => '',                  //font type
                'LINE_SIZE'         => 4,                   //line size for one row
                'BACKGROUND_COLOR'  => array(255,255,255),  //background color
                'BORDER_COLOR'      => array(0,92,177),     //border color
                'BORDER_SIZE'       => 0.1,                 //border size
                'BORDER_TYPE'       => '1',                 //border type, can be: 0, 1 or a combination of: "LRTB" 
                'TEXT'              => ' ',                 //default text
                //padding
                'PADDING_TOP'       => 0,
                'PADDING_RIGHT'     => 1,
                'PADDING_LEFT'      => 1,
                'PADDING_BOTTOM'    => 0,
        ),
    );
	
	//Initialize the table class, 3 columns and the custom configuration array
$oTable->initialize(array(40, 50, 30), $aDefaultConfiguration);

//header row configuration
$aHeader = array(
    array( 'TEXT'     => 'Header Row 2'),
    array( 'TEXT'     => 'Header Row 2 / 2-3',
           'COLSPAN'  => 2,//colspan
          ),
    //due to the colspan, the third header can be ignored
);

//add the second header row
$oTable->addHeader($aHeader);

//add some table rows
for ($j=1; $j<5; $j++)
{
    $aRow = Array();
    $aRow[0]['TEXT'] = "Line $j Text 1";    //text for column 0
    $aRow[1]['TEXT'] = "Line $j Text 2";    //text for column 1
    $aRow[2]['TEXT'] = "Line $j Text 3";    //text for column 2

    //override some settings for row 2
    if (2 == $j){
        $aRow[1]['TEXT_ALIGN'] = 'L';
        $aRow[1]['TEXT'] = "<pp>This is a <b>Multicell</b></pp>";
    }
    //add the row
    $oTable->addRow($aRow);
}

$aRow = array(
    array('TEXT'  => 'I am cell 1'),
    array('TEXT'  => 'I am cell 2'),
    array('TEXT'  => 'I am cell 3'),
);

//add the row to the table
$oTable->addRow($aRow);

$aRow = array(
    array('TEXT'  => '<t>This is a <b>Multicell</b></t>',
          'TEXT_ALIGN' => 'L'),
    array('TEXT'  => '<t>This is a <b>Multicell</b></t>'),
    array('TEXT'  => '<t>This is a <b>Multicell</b></t>'),
);

//add the row to the table
$oTable->addRow($aRow);
$oTable->close();
$oTable->output();
?>